// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't

//set if a>=


#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <winsock2.h>

#include "player.h"

class ObjectsState
{
public:
	int StartTime, ValidUntilTime;
	int CollisionCauser;
	int DestroyedObject;
	int CountExtraSlots;
	Object Objects[NumObjects];
public:
	ObjectsState(int StartTime, int DestroyedObject, const GameRam& ram)
	{
		this->StartTime = StartTime;
		this->DestroyedObject = DestroyedObject;
		ValidUntilTime = MaxInt;
		CollisionCauser = -1;
		CountExtraSlots = ram.GetCountExtraSlots();
		memcpy(Objects, ram.GetObjects(), sizeof(Objects));
		for(int i = 0; i < NumObjects; i++)
			assert(i != DestroyedObject || Objects[i].Status <= 0);
	}
};

class ShotInfoList
{
	int MaxCollisionTime;
	std::vector<ShotInfo> ShotInfos;
public:
	ShotInfoList()
	{
		MaxCollisionTime = 0;

		ShotInfo Shot;
		Shot.Time = MaxInt;
		Shot.Dir = Dir_None;
		Shot.TargetDirection = 0;
		ShotInfos.push_back(Shot);
		ShotInfos.push_back(Shot);
	}

	const ShotInfo& operator [](int Index) const
	{
		return ShotInfos[Index];
	}

	bool operator <(const ShotInfoList& rhs) const
	{
/*		if(!Bad && rhs.Bad)
			return true;
		if(Bad && !rhs.Bad)
			return false;*/
		return MaxCollisionTime < rhs.MaxCollisionTime;
	}
	bool SameMovement(const ShotInfoList& rhs) const
	{
		//Gibt true zurck, wenn der Spielstatus um ShotInfos[0].Time+1 bei beiden gleich ist
		if(this == &rhs)
			return true;
		if(ShotInfos[0].Time == MaxInt && rhs.ShotInfos[0].Time == MaxInt)
			return true;
		return ShotInfos[0].Time == rhs.ShotInfos[0].Time &&
			   ShotInfos[0].TargetDirection == rhs.ShotInfos[0].TargetDirection &&
			   (ShotInfos[0].TargetDirection == ShotInfos[1].TargetDirection ? Dir_None : ShotInfos[1].Dir) == (rhs.ShotInfos[0].TargetDirection == rhs.ShotInfos[1].TargetDirection ? Dir_None : rhs.ShotInfos[1].Dir);
	}

	size_t size() const
	{
		return ShotInfos.size();
	}

	int GetMaxCollisionTime() const
	{
		return MaxCollisionTime;
	}

	void DeleteFirst()
	{
		ShotInfos.erase(ShotInfos.begin());
	}

	void AddShot(const ShotInfo& Shot, int Index, bool CrossedNextDir)
	{
		ShotInfos.insert(ShotInfos.begin()+Index, Shot);

		assert(Shot.CollisionTime >= MaxCollisionTime);
		MaxCollisionTime = Shot.CollisionTime;

		if(ShotInfos[Index+1].Time != MaxInt && CrossedNextDir)
		{
#ifdef PRINT_DEBUG_INFO
			printf("Aendere Richtung!\n");
#endif
			if(Shot.Dir == Dir_Left)
				ShotInfos[Index+1].Dir = Dir_Right;
			else
			{
				assert(Shot.Dir == Dir_Right);
				ShotInfos[Index+1].Dir = Dir_Left;
			}
		}

#ifdef PRINT_DEBUG_INFO
		printf("%sSchiesse mit Slot %i um %i auf %x! Kol. voraus. bei %i %i  t=%i\n",
			ShotInfos[Index+1].Time != MaxInt ? "[Sek]" : "",
			Shot.ShotIndex-PlayerShotMinIndex,
			Shot.Time,
			Shot.Target,
			Shot.PositionX,
			Shot.PositionY,
			Shot.CollisionTime);
#endif
	}
};

std::vector<ObjectsState>* pObjectsStates = 0;

class ObjectsStateList
{
	std::vector<ObjectsState> ObjectsStates;
	GameRam Ram;
	const ShotInfoList& ShotInfos;
	int CurrentShotInfo;
public:
	ObjectsStateList(const GameRam& Ram, const ShotInfoList& ShotInfos)
		: ShotInfos(ShotInfos)
	{
		this->Ram = Ram;
		CurrentShotInfo = 0;
		ObjectsStates.push_back(ObjectsState(Ram.CurrentTime, -1, Ram));
	}

	void Update(int NeededTime)
	{
		assert(pObjectsStates == 0);
		pObjectsStates = &ObjectsStates;
		while(Ram.CurrentTime < NeededTime)
		{
			Ram.Move(ShotInfos[CurrentShotInfo], ShotInfos[CurrentShotInfo+1]);
			if(ShotInfos[CurrentShotInfo].Time == Ram.CurrentTime-1)
				CurrentShotInfo++;
		}
		pObjectsStates = 0;
	}

	const ObjectsState& operator [](int Index) const
	{
		return ObjectsStates[Index];
	}

	size_t GetCountStates()
	{
		return ObjectsStates.size();
	}
};




HWND hwnd;
HBITMAP hBitmap;
HDC hdcMem;
const int xFont=9, yFont=16;
const int xChars = 0x100*2;
const int yChars = 50;
GameRam GameRam::last_ram;

//std::vector<ShotInfo> ShotInfos;
//int MaxCollisionTime = 0;
std::vector<GameRam> GameRamsHistory;
int CurrentGameRam = -1;
bool updating = true;
int RunningTime = 0;
//bool* pErrorsOccured = 0;

//const int FutureTimeSteps = 43*10;
//int FutureTimeSteps = 2;
__int64* pScore = 0;


int AsteroidLifetime(char Status)
{
	assert(Status < 0);
	int Time = 0;
	while(Status < 0)
	{
		Status += (-Status >> 4) + 1;
		Time++;
	}
	return Time;
}


void GameRam::CalculateNextShot(const ShotInfoList& ShotInfos, int MinShootTime,
								std::multiset<ShotInfoList>& ShotInfosVariety)
{
	GameRam OriginalRam = *this;


	//Berechnen, zu welchen Zeitpunkten die Asteroiden sich verndern werden
	//Wenn ein Asteroid explodiert, die neuen Asteroiden erscheinen oder das UFO
	//erscheint oder seine Richtung ndert, werden alle Objekte in ObjectsStates gespeichert
	ObjectsStateList ObjectsStates(*this, ShotInfos);


	int MinCollisionAtTime = MaxInt;//Der frheste Zeitpunkt, zu dem ein Asteroid abgeschossen werden kann (0=jetzt)

	int CurrentObjectsStates = 0;
	int CurrentShotInfo = 0;
	int FreeRotationTime = 0;//Wie oft wir uns gerade gedreht haben knnten (wird jeden Frame inkrementiert, wenn der Spieler nicht tot ist, Hyperspace ausfhrt...)
	bool RotationWasLocked = false;
	int cShotsShot = 0;//Wie oft wir im aktuellen ObjectsState geschossen haben. Bentigen wir, da kein ObjectsStates 
	for(int t = 0; t < MinCollisionAtTime; t++)
	{
		//Zu welchem Zeitpunkt schieen wir am besten? (t=0: jetzt)
		if(t)
		{
			if(ShotInfos[CurrentShotInfo].Time == CurrentTime)
			{
				ShipDirection = ShotInfos[CurrentShotInfo].TargetDirection;
				FreeRotationTime = 0;
				RotationWasLocked = false;
			}

			if(NumPlayers &&
				Objects[PlayerIndex].Status >= 0 &&
				InvisibleTimer == 0)
				FreeRotationTime++;
			else
				RotationWasLocked = true;

			ObjectsStates.Update(CurrentTime+1);
			while(ObjectsStates[CurrentObjectsStates].ValidUntilTime == CurrentTime)
			{
				assert(ObjectsStates[CurrentObjectsStates+1].CountExtraSlots >= ObjectsStates[CurrentObjectsStates].CountExtraSlots - cShotsShot);
				CurrentObjectsStates++;
				cShotsShot = 0;
			}
			assert(CurrentTime < ObjectsStates[CurrentObjectsStates].ValidUntilTime);

			byte OldShipDirection = ShipDirection;
			Move(ShotInfos[CurrentShotInfo], ShotInfos[CurrentShotInfo+1]);
			ShipDirection = OldShipDirection;

			if(ShotInfos[CurrentShotInfo].Time == CurrentTime-1)
				CurrentShotInfo++;
		}

		if(ShotInfos[CurrentShotInfo].Time == CurrentTime)
			cShotsShot++;
		assert(ObjectsStates[CurrentObjectsStates].CountExtraSlots - cShotsShot >= 0);

		if(CurrentTime < MinShootTime)
			continue;

		//Knnen wir schieen?
		if(FireHyperspaceToggle & 0x80 || InvisibleTimer)
			continue;

		//Schieen wir jetzt sowieso oder im nchsten Frame? (falls im nchsten drfen wir jetzt nicht schieen, weil wir sonst nicht im nchsten Frame schieen knnen)
		if(ShotInfos[CurrentShotInfo].Time == CurrentTime || ShotInfos[CurrentShotInfo].Time == CurrentTime+1)
			continue;

		if(ShotInfos[CurrentShotInfo].Time != MaxInt && ShotInfos[CurrentShotInfo].RotationWasLocked)
			continue;

		//Der nchste Schuss hat keine freien Slots mehr fr uns. Da die Kollision dieses Schusses nach dem Schuss des nchsten Schusses sein muss, knnen wirs gleich vergessen.
		//if(ShotInfos[CurrentShotInfo].Time != MaxInt && ShotInfos[CurrentShotInfo].CountExtraSlots == 0)
		if(ObjectsStates[CurrentObjectsStates].CountExtraSlots - cShotsShot <= 0)
			continue;

		//Ist noch ein Slot frei?
		int NewShot = PlayerShotMaxIndex;
		while(Objects[NewShot].Status)
			if(NewShot-- == PlayerShotMinIndex)
				break;
		if(NewShot == PlayerShotMinIndex-1)
		{
			assert(0);
			continue;//Kein Slot frei
		}

		//Je nach Abschusszeitpunkt berlebt der Schuss unterschiedlich lange
		//int CollisionAtTime = Min(ShotLifetime-4 + (3-(FastTimer&3)) + t, MinCollisionAtTime);

		//Gibt an, wie wir uns zu diesem Zeitpunkt gedreht haben werden knnen
		//if(CurrentShotInfo == 0)
		//	AbleToRotateCounter--;
		int MinDeltaDir = -FreeRotationTime * RotationSpeed;
		int MaxDeltaDir = FreeRotationTime * RotationSpeed;
		if(ShotInfos[CurrentShotInfo].Time != MaxInt)
		{
			//Dafr sorgen, dass der nchste Schuss nach diesem Schuss erreicht werden kann
			const int PossibleRotation = (ShotInfos[CurrentShotInfo].Time-CurrentTime) * RotationSpeed;
			const int NeededRot = NeededRotation(ShipDirection, ShotInfos[CurrentShotInfo].TargetDirection, ShotInfos[CurrentShotInfo].Dir);
			MinDeltaDir = Max(MinDeltaDir, NeededRot - PossibleRotation);
			MaxDeltaDir = Min(MaxDeltaDir, NeededRot + PossibleRotation);
		}
		MinDeltaDir = Max(MinDeltaDir, -129/RotationSpeed*RotationSpeed); // In Tests hat sich herausgestellt, dass grere DeltaDirs zu 99,99% nicht benutzt werden. Wir sparen uns also die Rechenzeit
		MaxDeltaDir = Min(MaxDeltaDir, 129/RotationSpeed*RotationSpeed);
		assert(MinDeltaDir%RotationSpeed == 0);
		assert(MaxDeltaDir%RotationSpeed == 0);
		//Wir prfen erst die betragsmig kleinen DeltaDirs, damit diese bei gleichem Kollisionszeitpunkt bevorzugt werden
		//Das gibt ordentlich Punkte:)
		int MaxAbsDeltaDir = Max(MaxDeltaDir, -MinDeltaDir) / RotationSpeed * 2;
		for(int AbsDeltaDir = 0; AbsDeltaDir <= MaxAbsDeltaDir; AbsDeltaDir++)
		{
			int DeltaDir;
			if(AbsDeltaDir == 0)
				DeltaDir = 0;
			else if(AbsDeltaDir%2 == 0)
				DeltaDir = AbsDeltaDir / 2 * RotationSpeed;
			else
				DeltaDir = (AbsDeltaDir+1) / 2 * -RotationSpeed;
			if(DeltaDir < MinDeltaDir || DeltaDir > MaxDeltaDir)
				continue;
			//if(DeltaDir != MinDeltaDir && DeltaDir != MaxDeltaDir)
			//	continue;///////////////////

			SimulateShot(ObjectsStates, ShotInfos, CurrentObjectsStates, CurrentShotInfo, cShotsShot,
				         t, OriginalRam, NewShot, DeltaDir, MinCollisionAtTime, ShotInfosVariety, RotationWasLocked);

			//Hier simulieren wir einen Schuss in t Frames bei einer Schiffsdrehung von DeltaDir (relativ zur Richtung beim letzten Schuss)

/*			word StartX = Objects[PlayerIndex].PositionX;
			word StartY = Objects[PlayerIndex].PositionY;
			char VelocityX = Objects[PlayerIndex].VelocityX;
			char VelocityY = Objects[PlayerIndex].VelocityY;
			ShootLocationFromAngle(ShipDirection+DeltaDir,
								   StartX,
								   StartY,
								   VelocityX,
								   VelocityY);

			int CurrentObjectsStates2 = CurrentObjectsStates;
			int CurrentShotInfo2 = CurrentShotInfo;
			int cShotsShot2 = cShotsShot;
			for(int t2 = t; t2 < CollisionAtTime; t2++)
			{
				int CurrentTime2 = CurrentTime+t2-t;
				ObjectsStates.Update(CurrentTime2+1);
				//Wir simulieren die Bewegung des Schusses

				if(ShotInfos[CurrentShotInfo2].Time == CurrentTime2)
				{
					CurrentShotInfo2++;
					cShotsShot2++;
					assert(ObjectsStates[CurrentObjectsStates2].CountExtraSlots - cShotsShot2 >= 0);
					if(ObjectsStates[CurrentObjectsStates2].CountExtraSlots - cShotsShot2 <= 0)
						break;
				}

				while(CurrentTime2 == ObjectsStates[CurrentObjectsStates2].ValidUntilTime &&
					NewShot < ObjectsStates[CurrentObjectsStates2].CollisionCauser)
				{
					CurrentObjectsStates2++;
					cShotsShot2 = 0;
				}
				assert(CurrentTime2 <= ObjectsStates[CurrentObjectsStates2].ValidUntilTime);

				const Object* Objects2 = ObjectsStates[CurrentObjectsStates2].Objects;

				for(int Object = SaucerIndex-2; Object >= 0; Object--)
				{
					//Trifft der Schuss ein Objekt?
					if(Objects2[Object].Status <= 0)
						continue;
					bool collision = AreObjectsNear(NewShot,
													MoveLinearX(StartX, VelocityX, t2-t+1),
													MoveLinearY(StartY, VelocityY, t2-t+1),
													ShotLifetime/4,//wird ignoriert
						                            Object,
													MoveLinearX(Objects2[Object].PositionX, Objects2[Object].VelocityX, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1),
													MoveLinearY(Objects2[Object].PositionY, Objects2[Object].VelocityY, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1),
													Objects2[Object].Status);
					if(!collision)
						continue;
					//Wir treffen das Objekt!!

					//Wir schieen aber nicht, falls es gleich (noch im gleichen Frame) von einem anderen Schuss
					//getroffen wird.
					//Dies kann passieren, wenn unser Schuss einen hheren Index bekommt als der, der auf dieses
					//Objekt unterwegs ist, und wir das Objekt deshalb trotzdem erreichen knnen, obwohl wir
					//offensichtlich spter schieen. (Schsse mit hherem Index werden von Asteroids zuerst abgearbeitet)
					//Dieser Fall tritt aber zugegebenermaen sehr selten ein..
					int CurrentObjectsStates3 = CurrentObjectsStates2;
					while(CurrentTime2 == ObjectsStates[CurrentObjectsStates3++].ValidUntilTime)
						if(ObjectsStates[CurrentObjectsStates3].DestroyedObject == Object)
						{
#ifdef PRINT_DEBUG_INFO
							printf("Vermeide Schuss mit Slot %i auf %x um %i\n", NewShot-PlayerShotMinIndex, Object, CurrentTime);
#endif
							break;
						}
					if(CurrentTime2 == ObjectsStates[CurrentObjectsStates3-1].ValidUntilTime)
					{
						t2 = MaxInt;//Dieses DeltaDir kommt nicht in Frage
						break;
					}

//					while(CurrentObjectsStates3 < ObjectsStates.GetCountStates())
//						assert(ObjectsStates[CurrentObjectsStates3++].DestroyedObject != Object);

					//Wenn wir einen groen Asteroiden abknallen mssen wir darauf achten, dass es genug
					//Slots fr die zwei kleinen gibt.
					if(!(Objects2[Object].Status & 0x01))
					{
						int cFreeAsteroidSlots = 0;
						for(int i = AsteroidMinIndex; i <= AsteroidMaxIndex; i++)
							if(Objects2[i].Status == 0 ||
								Objects2[i].Status < 0 && AsteroidLifetime(Objects2[i].Status) <= CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1)
							{
								if(++cFreeAsteroidSlots == 2)
									break;
							}
						if(cFreeAsteroidSlots != 2)
						{
							//Wenn wir dieses Asteroiden abknallen wrden, wrden keine 2 kleinere Asteroiden entstehen
							//Wir vermeiden also diese Richtung zu diesem Zeitpunkt
#ifdef PRINT_DEBUG_INFO
							printf("Vermeide Schuss mit Slot %i auf %x um %i, da zu wenig Slots da sind\n", NewShot-PlayerShotMinIndex, Object, CurrentTime);
#endif
							t2 = MaxInt;
							break;
						}
					}

					if(CurrentTime2 < ShotInfos.GetMaxCollisionTime())
					{
#ifdef PRINT_DEBUG_INFO
						printf("Zu frueher Schuss\n");
#endif
						t2 = MaxInt;
						break;
					}


					bool CrossedNextDir = false;
					if(ShotInfos[CurrentShotInfo].Time != MaxInt && DeltaDir)
					{
						for(int i = 0; i != DeltaDir; i += (DeltaDir>0?RotationSpeed:-RotationSpeed))
							if(byte(i+ShipDirection) == ShotInfos[CurrentShotInfo].TargetDirection)
							{
								CrossedNextDir = true;
								break;
							}
					}

					CollisionAtTime = t2;
					MinCollisionAtTime = t2;

					ShotInfo BestShotInfo;
					BestShotInfo.Time = CurrentTime;
					if(DeltaDir > 0)
						BestShotInfo.Dir = Dir_Left;
					else if(DeltaDir < 0)
						BestShotInfo.Dir = Dir_Right;
					else
						BestShotInfo.Dir = Dir_None;
					BestShotInfo.TargetDirection = ShipDirection+DeltaDir;
					BestShotInfo.CollisionTime = CurrentTime2;
				
					BestShotInfo.ShotIndex = NewShot;
					BestShotInfo.PositionX = MoveLinearX(StartX, VelocityX, t2-t+1);
					BestShotInfo.PositionY = MoveLinearY(StartY, VelocityY, t2-t+1);
					BestShotInfo.Target = Object;
					BestShotInfo.StartX = StartX;
					BestShotInfo.StartY = StartY;
					BestShotInfo.VelocityX = VelocityX;
					BestShotInfo.VelocityY = VelocityY;
					BestShotInfo.TargetPositionX = MoveLinearX(Objects2[Object].PositionX, Objects2[Object].VelocityX, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1);
					BestShotInfo.TargetPositionY = MoveLinearY(Objects2[Object].PositionY, Objects2[Object].VelocityY, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1);
					BestShotInfo.TargetStatus = Objects2[Object].Status;

					ShotInfoList ShotInfos2 = ShotInfos;
					ShotInfos2.AddShot(BestShotInfo, CurrentShotInfo, CrossedNextDir);
					OriginalRam.CheckForErrors(ShotInfos2, BestShotInfo.CollisionTime+20);
					ShotInfosVariety.insert(ShotInfos2);
					break;
				}
				if(t2 == MaxInt)
					break;
				while(CurrentTime2 == ObjectsStates[CurrentObjectsStates2].ValidUntilTime)
				{
					CurrentObjectsStates2++;
					cShotsShot2 = 0;
				}
				assert(CurrentTime2 < ObjectsStates[CurrentObjectsStates2].ValidUntilTime);
			}*/
		}
	}
	*this = OriginalRam;
}

void GameRam::SimulateShot(ObjectsStateList& ObjectsStates, const ShotInfoList& ShotInfos,
						   const int CurrentObjectsStates, const int CurrentShotInfo, const int cShotsShot,
						   const int t, GameRam& OriginalRam,
						   const int ShotIndex, const int DeltaDir, int& MinCollisionAtTime,
						   std::multiset<ShotInfoList>& ShotInfosVariety, bool RotationWasLocked)
{
	word StartX = Objects[PlayerIndex].PositionX;
	word StartY = Objects[PlayerIndex].PositionY;
	char VelocityX = Objects[PlayerIndex].VelocityX;
	char VelocityY = Objects[PlayerIndex].VelocityY;
	ShootLocationFromAngle(ShipDirection+DeltaDir,
						   StartX,
						   StartY,
						   VelocityX,
						   VelocityY);

	//Je nach Abschusszeitpunkt berlebt der Schuss unterschiedlich lange
	int CollisionAtTime = Min(ShotLifetime-4 + (3-(FastTimer&3)) + t, MinCollisionAtTime);

	int CurrentObjectsStates2 = CurrentObjectsStates;
	int CurrentShotInfo2 = CurrentShotInfo;
	int cShotsShot2 = cShotsShot;
	for(int t2 = t; t2 < CollisionAtTime; t2++)
	{
		int CurrentTime2 = CurrentTime+t2-t;
		ObjectsStates.Update(CurrentTime2+1);
		//Wir simulieren die Bewegung des Schusses

		if(ShotInfos[CurrentShotInfo2].Time == CurrentTime2)
		{
			CurrentShotInfo2++;
			cShotsShot2++;
			assert(ObjectsStates[CurrentObjectsStates2].CountExtraSlots - cShotsShot2 >= 0);
			if(ObjectsStates[CurrentObjectsStates2].CountExtraSlots - cShotsShot2 <= 0)
				break;
		}

		while(CurrentTime2 == ObjectsStates[CurrentObjectsStates2].ValidUntilTime &&
			ShotIndex < ObjectsStates[CurrentObjectsStates2].CollisionCauser)
		{
			CurrentObjectsStates2++;
			cShotsShot2 = 0;
		}
		assert(CurrentTime2 <= ObjectsStates[CurrentObjectsStates2].ValidUntilTime);

		const Object* Objects2 = ObjectsStates[CurrentObjectsStates2].Objects;

		for(int Object = SaucerIndex-2; Object >= 0; Object--)
		{
			//Trifft der Schuss ein Objekt?
			if(Objects2[Object].Status <= 0)
				continue;
			bool collision = AreObjectsNear(ShotIndex,
											MoveLinearX(StartX, VelocityX, t2-t+1),
											MoveLinearY(StartY, VelocityY, t2-t+1),
											ShotLifetime/4,//wird ignoriert
				                            Object,
											MoveLinearX(Objects2[Object].PositionX, Objects2[Object].VelocityX, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1),
											MoveLinearY(Objects2[Object].PositionY, Objects2[Object].VelocityY, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1),
											Objects2[Object].Status);
			if(!collision)
				continue;
			//Wir treffen das Objekt!!

			//Wir schieen aber nicht, falls es gleich (noch im gleichen Frame) von einem anderen Schuss
			//getroffen wird.
			//Dies kann passieren, wenn unser Schuss einen hheren Index bekommt als der, der auf dieses
			//Objekt unterwegs ist, und wir das Objekt deshalb trotzdem erreichen knnen, obwohl wir
			//offensichtlich spter schieen. (Schsse mit hherem Index werden von Asteroids zuerst abgearbeitet)
			//Dieser Fall tritt aber zugegebenermaen sehr selten ein..
			int CurrentObjectsStates3 = CurrentObjectsStates2;
			while(CurrentTime2 == ObjectsStates[CurrentObjectsStates3++].ValidUntilTime)
				if(ObjectsStates[CurrentObjectsStates3].DestroyedObject == Object)
				{
#ifdef PRINT_DEBUG_INFO
					printf("Vermeide Schuss mit Slot %i auf %x um %i\n", ShotIndex-PlayerShotMinIndex, Object, CurrentTime);
#endif
					break;
				}
			if(CurrentTime2 == ObjectsStates[CurrentObjectsStates3-1].ValidUntilTime)
			{
				t2 = MaxInt;//Dieses DeltaDir kommt nicht in Frage
				break;
			}

			//Wenn wir einen groen Asteroiden abknallen mssen wir darauf achten, dass es genug
			//Slots fr die zwei kleinen gibt.
			if(!(Objects2[Object].Status & 0x01))
			{
				int cFreeAsteroidSlots = 0;
				for(int i = AsteroidMinIndex; i <= AsteroidMaxIndex; i++)
					if(Objects2[i].Status == 0 ||
						Objects2[i].Status < 0 && AsteroidLifetime(Objects2[i].Status) <= CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1)
					{
						if(++cFreeAsteroidSlots == 2)
							break;
					}
				if(cFreeAsteroidSlots != 2)
				{
					//Wenn wir dieses Asteroiden abknallen wrden, wrden keine 2 kleinere Asteroiden entstehen
					//Wir vermeiden also diese Richtung zu diesem Zeitpunkt
#ifdef PRINT_DEBUG_INFO
					printf("Vermeide Schuss mit Slot %i auf %x um %i, da zu wenig Slots da sind\n", ShotIndex-PlayerShotMinIndex, Object, CurrentTime);
#endif
					t2 = MaxInt;
					break;
				}
			}

			if(CurrentTime2 < ShotInfos.GetMaxCollisionTime())
			{
//#ifdef PRINT_DEBUG_INFO
//				printf("Zu frueher Schuss\n");
//#endif
				t2 = MaxInt;
				break;
			}

			MinCollisionAtTime = CollisionAtTime = t2;

			ShotInfo BestShotInfo;
			BestShotInfo.Time = CurrentTime;
			if(DeltaDir > 0)
				BestShotInfo.Dir = Dir_Left;
			else if(DeltaDir < 0)
				BestShotInfo.Dir = Dir_Right;
			else
				BestShotInfo.Dir = Dir_None;
			BestShotInfo.TargetDirection = ShipDirection+DeltaDir;
			BestShotInfo.CollisionTime = CurrentTime2;
			BestShotInfo.RotationWasLocked = RotationWasLocked;

			BestShotInfo.ShotIndex = ShotIndex;
			BestShotInfo.PositionX = MoveLinearX(StartX, VelocityX, t2-t+1);
			BestShotInfo.PositionY = MoveLinearY(StartY, VelocityY, t2-t+1);
			BestShotInfo.Target = Object;
			BestShotInfo.StartX = StartX;
			BestShotInfo.StartY = StartY;
			BestShotInfo.VelocityX = VelocityX;
			BestShotInfo.VelocityY = VelocityY;
			BestShotInfo.TargetPositionX = MoveLinearX(Objects2[Object].PositionX, Objects2[Object].VelocityX, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1);
			BestShotInfo.TargetPositionY = MoveLinearY(Objects2[Object].PositionY, Objects2[Object].VelocityY, CurrentTime2-ObjectsStates[CurrentObjectsStates2].StartTime+1);
			BestShotInfo.TargetStatus = Objects2[Object].Status;

			bool CrossedNextDir = false;
			if(ShotInfos[CurrentShotInfo].Time != MaxInt && DeltaDir)
			{
				for(int i = 0; i != DeltaDir; i += (DeltaDir>0?RotationSpeed:-RotationSpeed))
					if(byte(ShipDirection+i) == ShotInfos[CurrentShotInfo].TargetDirection)
					{
						CrossedNextDir = true;
						break;
					}
			}


			ShotInfoList ShotInfos2 = ShotInfos;
			ShotInfos2.AddShot(BestShotInfo, CurrentShotInfo, CrossedNextDir);
			OriginalRam.CheckForErrors(ShotInfos2, BestShotInfo.CollisionTime+20);
			ShotInfosVariety.insert(ShotInfos2);
			break;
		}
		if(t2 == MaxInt)
			break;
		while(CurrentTime2 == ObjectsStates[CurrentObjectsStates2].ValidUntilTime)
		{
			CurrentObjectsStates2++;
			cShotsShot2 = 0;
		}
		assert(CurrentTime2 < ObjectsStates[CurrentObjectsStates2].ValidUntilTime);
	}
}

void GameRam::CheckForErrors(const ShotInfoList& ShotInfos, int UntilTime)
{
	//Zuknftige Schritte simulieren, um schon jetzt Fehler abzufangen, die spter auftreten knnen (erleichtert Debugging)
	GameRam OriginalRam = *this;
	//bool ErrorsOccured = false;
	//pErrorsOccured = &ErrorsOccured;
	int CurrentShotInfo = 0;
	while(CurrentTime != UntilTime)
	{
		Move(ShotInfos[CurrentShotInfo], ShotInfos[CurrentShotInfo+1]);
		if(ShotInfos[CurrentShotInfo].Time == CurrentTime-1)
			CurrentShotInfo++;
	}
	*this = OriginalRam;
	/*pErrorsOccured = 0;
	if(ErrorsOccured)
	{
		printf("Fehler...:(\n");
		while(true)
			;
		MessageBeep(0);
		//exit(0);
		// CalcDirInfos(pShotInfo, pDeltaDir, CalcSecondShoot, FixedShootAtTime, FixedShootAtDir, FixedKey);
	}*/
}


//Prft, ob das Objekt CollisionCauser mit irgendwas kollidiert und fhrt
//entsprechende Aktionen aus
void GameRam::CheckCollisions(byte CollisionCauser, DecisionList& Decisions)//sub_69F0
{
	if(Objects[CollisionCauser].Status <= 0)
		return;
	byte y = SaucerIndex;
	if(CollisionCauser < PlayerShotMinIndex)//CollisionCauser ist kein Schuss vom Spieler
		y--;// kann also nicht mit dem UFO kollidieren
	if(CollisionCauser == PlayerIndex)
		y--;//Spieler kann nicht mit sich selbst kollidieren
	do
	{
		if(Objects[y].Status <= 0)
			continue;

		int cCollisionCombinations = 0, cNoCollisionCombinations = 0;
		bool OnlyCollisions = false;
		if(Decisions.ObjectCollision[CollisionCauser-PlayerIndex] == 0)
			OnlyCollisions = true;

		Object NewCollisionCauser(Objects[CollisionCauser].Status);
		Object NewTarget(Objects[y].Status);

//		for(int ax = 0; ax < Objects[CollisionCauser].cAltX; ax++)
//		for(int ay = 0; ay < Objects[CollisionCauser].cAltY; ay++)
//		for(int bx = 0; bx < Objects[y].cAltX; bx++)
//		for(int by = 0; by < Objects[y].cAltY; by++)
		for(int ax = Objects[CollisionCauser].cAltX-1; ax >= 0; ax--)
		for(int ay = Objects[CollisionCauser].cAltY-1; ay >= 0; ay--)
		for(int bx = Objects[y].cAltX-1; bx >= 0; bx--)
		for(int by = Objects[y].cAltY-1; by >= 0; by--)
		{
			bool Near = AreObjectsNear(CollisionCauser,
									   Objects[CollisionCauser].AltPX[ax],
									   Objects[CollisionCauser].AltPY[ay],
									   Objects[CollisionCauser].Status,
									   y,
									   Objects[y].AltPX[bx],
									   Objects[y].AltPY[by],
									   Objects[y].Status);
			if(Near)
				cCollisionCombinations++;
			else
				cNoCollisionCombinations++;
			if(Near == OnlyCollisions)
			{
				NewCollisionCauser.AddLocation(Objects[CollisionCauser].AltPX[ax], Objects[CollisionCauser].AltPY[ay],
											   Objects[CollisionCauser].AltVX[ax], Objects[CollisionCauser].AltVY[ay]);
				NewTarget.AddLocation(Objects[y].AltPX[bx], Objects[y].AltPY[by],
								 	  Objects[y].AltVX[bx], Objects[y].AltVY[by]);
			}
		}
		if(cNoCollisionCombinations && cCollisionCombinations == 0)
		{
			//Es sind eine oder mehrere Kombinationen, die alle nicht kollidieren
			//->Kein Entscheidungsproblem
			continue;
		}
		else if(cNoCollisionCombinations == 0 && cCollisionCombinations)
		{
			//Es gibt nur Kollisionen
			//->Kein Entscheidungsproblem
		}
		else if(OnlyCollisions)
		{
			//Wir haben uns frher dafr entschieden, dass die Objekte nicht kollidieren,
			//aber anscheinend festgestellt, dass das nicht passte.
			//Wir entscheiden uns jetzt also per Vorgabe fr diese Kollisionen
#ifdef PRINT_DECISIONS
			printf("Entscheide fuer die %i Kollisionen um %i\n", cCollisionCombinations, CurrentTime);
#endif
			Objects[CollisionCauser] = NewCollisionCauser;
			assert(Objects[CollisionCauser].IsValid());
			Objects[y] = NewTarget;
			assert(Objects[y].IsValid());
			//continue;
		}
		else if(cNoCollisionCombinations && cCollisionCombinations)
		{
			//Einige kollidieren, einige nicht.
			//Wir entscheiden uns fr die Kombinationen, die nicht kollidieren.
			//Falls sie es doch tun, werden wir uns spter hier anders entscheiden
#ifdef PRINT_DECISIONS
			printf("Entscheide gegen Kollision um %i. Kollisionen: %i\n", CurrentTime, cCollisionCombinations);
#endif
			Decisions.ObjectCollision[CollisionCauser-PlayerIndex] = 1;

			Objects[CollisionCauser] = NewCollisionCauser;
			assert(Objects[CollisionCauser].IsValid());
			Objects[y] = NewTarget;
			assert(Objects[y].IsValid());
			continue;//Keine Kollision
		}
		else
			assert(0);

		//Wir kollidieren!

		if(CollisionCauser >= PlayerShotMinIndex)
		{
#ifdef PRINT_DEBUG_INFO
			if(ShotInfosCheck[CollisionCauser-PlayerShotMinIndex].PositionX != ShotX ||
				ShotInfosCheck[CollisionCauser-PlayerShotMinIndex].PositionY != ShotY ||
				ShotInfosCheck[CollisionCauser-PlayerShotMinIndex].CollisionTime != CurrentTime)
			{
				printf("Kollision bei Shot %i verschieden X: %i!=%i  Y: %i!=%i  t: %i!=%i tar: %x!=%x\n",
					CollisionCauser-PlayerShotMinIndex,
					ShotInfosCheck[CollisionCauser-PlayerShotMinIndex].PositionX, ShotX,
					ShotInfosCheck[CollisionCauser-PlayerShotMinIndex].PositionY, ShotY,
					ShotInfosCheck[CollisionCauser-PlayerShotMinIndex].CollisionTime, CurrentTime,
					ShotInfosCheck[CollisionCauser-PlayerShotMinIndex].Target, y);
				//*pErrorsOccured = true;
				//MessageBeep(0);
			}
			if(	ShotInfosCheck[CollisionCauser-PlayerShotMinIndex].Target != y ||
				ShotInfosCheck[CollisionCauser-PlayerShotMinIndex].TargetPositionX != Objects[y].PositionX ||
				ShotInfosCheck[CollisionCauser-PlayerShotMinIndex].TargetPositionY != Objects[y].PositionY ||
				ShotInfosCheck[CollisionCauser-PlayerShotMinIndex].TargetStatus != Objects[y].Status)
			{
				printf("Ziel verschieden. Shit happens...\n");
			}
#endif
			ShotInfosCheck[CollisionCauser-PlayerShotMinIndex] = ShotInfo();
		}
		if(OnCollision(CollisionCauser, y, Decisions) && pObjectsStates)
		{
			//An den Objekten hat sich etwas wichtiges gendert. Fr die KI speichern.
			pObjectsStates->back().ValidUntilTime = CurrentTime;
			pObjectsStates->back().CollisionCauser = CollisionCauser;
			pObjectsStates->push_back(ObjectsState(CurrentTime+1, y, *this));
		}
		return;//Nur eine Kollision pro Objekt
	}while(y--);
#ifdef PRINT_DEBUG_INFO
	if(CollisionCauser >= PlayerShotMinIndex && ShotInfosCheck[CollisionCauser-PlayerShotMinIndex].CollisionTime == CurrentTime)
	{
		printf("Ziel nicht getroffen. Shit happens...\n");
		//assert(ShotInfosCheck[CollisionCauser-PlayerShotMinIndex].ShotIndex == CollisionCauser);
		//assert(ShotInfosCheck[CollisionCauser-PlayerShotMinIndex].CollisionFastTimer != FastTimer);
	}
#endif
}

void GameRam::ResetAsteroids()//sub_7168
{
	byte x = PlayerIndex-1;
	byte a = NewLevelStartCountdown;
	if(a) goto loc_71DF;
	if(Objects[SaucerIndex].Status)
		return;
	Objects[SaucerIndex].VelocityX = 0;
	Objects[SaucerIndex].VelocityY = 0;

	_2FD++;
	if(_2FD >= 0x0B)
        _2FD--;

	a = NumAsteroidsStart;
	a += 2;
	if(a >= 0x0B)
		a = 0x0B;
	NumAsteroids = a;
	NumAsteroidsStart = a;
	byte tmp8 = a;
	byte y = SaucerIndex;
loc_719D:
	Objects[x].Status = ((Rand()&0x18)|0x04);
	sub_7203(x, y);
	a = Rand();
	bool c;
	ShiftRight(a, c);
	a &= 0x1F;
	if(!c) goto loc_71C5;
	if(a >= 0x18)
		a &= 0x17;
	HighByte(Objects[x].PositionY) = a;
//	LowByte(Objects[x].PositionY) = 0xff;////////
	Objects[x].PositionX = 0;
	goto loc_71D0;
loc_71C5:
	HighByte(Objects[x].PositionX) = a;
//	LowByte(Objects[x].PositionX) = 0xff;////////
	Objects[x].PositionY = 0;
loc_71D0:
	x--;
	tmp8--;
	if(tmp8) goto loc_719D;
	SaucerCountdown = 0x7F;
	//Var(RAM_2FC) = 0x30;
loc_71DF:
	a = 0;
loc_71E1:
	Objects[x].Status = a;
	x--;
	if(char(x) >= 0) goto loc_71E1;
	if(pObjectsStates)
	{
		pObjectsStates->back().ValidUntilTime = CurrentTime;
		pObjectsStates->back().CollisionCauser = -1;
		pObjectsStates->push_back(ObjectsState(CurrentTime+1, -1, *this));
	}
}

class GameCombination
{
public:
	GameRam Game;
	std::map<DecisionList, GameRam> DecisionGameStates;
public:
	bool Move(word* VRams[DecisionTime], int CurrentVRam, int CurrentVRamTime, const byte* ram,
			  int TargetTime, DecisionList& NewDecisions,
			  std::vector<GameCombination>& GameCombinations, bool Inner, GameRam* pOuterGame)
	{
		while(Game.CurrentTime != TargetTime)
		{
			try
			{
				assert(CurrentVRamTime - Game.CurrentTime < DecisionTime);
				assert(NewDecisions.Time == Game.CurrentTime);
				word* VRam = VRams[(CurrentVRam - (CurrentVRamTime - Game.CurrentTime) + DecisionTime) % DecisionTime];
				Game.Move_(KeysPacket(), ShotInfo(), ram, VRam, NewDecisions);
			}
			catch(VRamInvalidException)
			{
				if(NewDecisions.HasCombinations())
				{
					//printf("Entscheidung um %i\n", GameRam::last_ram.CurrentTime);
					if(DecisionGameStates.find(NewDecisions) != DecisionGameStates.end())
						DecisionGameStates.erase(NewDecisions);
					DecisionGameStates[NewDecisions] = GameRam::last_ram;
				}
				if(DecisionGameStates.empty())
				{
					NewDecisions = DecisionList(0);
					return false;
				}
				bool NextRandomSeed = false;
				NewDecisions = DecisionGameStates.begin()->first;
				while(!NewDecisions.Next(NextRandomSeed))
				{
					DecisionGameStates.erase(DecisionGameStates.begin());
					if(DecisionGameStates.empty())
					{
						NewDecisions = DecisionList(0);
						return false;
					}
					NewDecisions = DecisionGameStates.begin()->first;
					printf("Springe zu Zeitpunkt %i zurueck\n", NewDecisions.Time);
				}
#ifdef PRINT_DECISIONS
				printf("Aendere Entscheidung\n");
#endif
				if(NextRandomSeed)
					DecisionGameStates.begin()->second.Rand();
				assert(CurrentVRamTime - DecisionGameStates.begin()->first.Time < DecisionTime);
				Game = DecisionGameStates.begin()->second;
				DecisionGameStates.erase(DecisionGameStates.begin());
				DecisionGameStates[NewDecisions] = Game;
				continue;
				throw;//////////////////////
			}
			if(NewDecisions.HasCombinations())
			{
				//printf("Entscheidung um %i\n", GameRam::last_ram.CurrentTime);
				if(DecisionGameStates.find(NewDecisions) != DecisionGameStates.end())
					DecisionGameStates.erase(NewDecisions);
				DecisionGameStates[NewDecisions] = GameRam::last_ram;
			}
			NewDecisions = DecisionList(Game.CurrentTime);
		}
		
		for(std::map<DecisionList, GameRam>::iterator i = DecisionGameStates.begin();
			i != DecisionGameStates.end();
			)
		{
			if(i->first.Time <= CurrentVRamTime - DecisionTime + 1)
			{
				assert(i->first.Time == CurrentVRamTime - DecisionTime + 1);
				bool NextRandomSeed = false;
				NewDecisions = i->first;
				if(Inner)
				{
					*pOuterGame = i->second;
					DecisionGameStates.erase(i);
					return true;
				}
				while(NewDecisions.Next(NextRandomSeed))
				{
					printf("Versuche simultanen\n");
					GameCombination NewGameCombination;
					NewGameCombination.Game = i->second;
					if(NextRandomSeed)
						NewGameCombination.Game.Rand();
					/*NewGameCombination.DecisionGameStates = DecisionGameStates;
					for(std::map<DecisionList, GameRam>::iterator j = NewGameCombination.DecisionGameStates.begin();
						j != NewGameCombination.DecisionGameStates.end();
						)
					{
						if(j->first.Time <= CurrentVRamTime - DecisionTime + 1)
							j = NewGameCombination.DecisionGameStates.erase(j);
						else
							j++;
					}*/
					if(NewGameCombination.Move(VRams, CurrentVRam, CurrentVRamTime, ram,
											   CurrentVRamTime+1, NewDecisions, GameCombinations, true, &i->second))
					{
						printf("Erstelle simultanen Spielzustand!!\n");
						GameCombinations.push_back(NewGameCombination);
					}
					else
						printf("Simultaner Spielzustand hat nicht geklappt...\n");
				}
				i = DecisionGameStates.erase(i);
			}
			else
				i++;
		}
		NewDecisions = DecisionList(0);
		return true;
	}
	bool Check(const byte* ram, int no)
	{
		//if(Game.RandomSeed1 != ram[0x5F])
		//	printf("Rand out of sync\n");;
		//Game.RandomSeed1 = ram[0x5F];
		//Game.RandomSeed2 = ram[0x60];
		Game.SaucerCountdown = ram[0x02F7];
		Game.SaucerCountdownStart = ram[0x02F8];
		//Game.FastTimer = ram[0x5C];
		Game._2F9 = ram[0x02F9];
		Game._2FD = ram[0x02FD];
		if(!Game.Check(ram, KeysPacket(), ShotInfo(), false, 0, 0))
		{
			printf("No %i falsch\n", no);
			if(DecisionGameStates.empty() || DecisionGameStates.begin()->first.Time < Game.CurrentTime - DecisionTime)
				return false;
		}
		return true;
	}
/*private:
	bool Move(word VRams[DecisionTime][512], int CurrentVRam, int CurrentVRamTime, const byte* ram, int TargetTime,
			  DecisionList NewDecisions)
	{
		while(Game.CurrentTime != TargetTime)
		{
			try
			{
				assert(CurrentVRamTime - Game.CurrentTime < DecisionTime);
				assert(NewDecisions.Time == Game.CurrentTime);
				word* VRam = VRams[(CurrentVRam - (CurrentVRamTime - Game.CurrentTime) + DecisionTime) % DecisionTime];
				Game.Move_(KeysPacket(), ShotInfo(), ram, VRam, NewDecisions);
			}
			catch(VRamInvalidException)
			{
				if(NewDecisions.HasCombinations())
				{
					printf("Entscheidung um %i\n", GameRam::last_ram.CurrentTime);
					DecisionGameStates[NewDecisions] = GameRam::last_ram;
				}
				if(DecisionGameStates.empty())
 					return false;
				bool NextRandomSeed = false;
				while(!DecisionGameStates.begin()->first.Next(NextRandomSeed))
				{
					DecisionGameStates.erase(DecisionGameStates.begin());
					if(DecisionGameStates.empty())
						return false;
					printf("Springe zu Zeitpunkt %i zurueck\n", DecisionGameStates.begin()->first.Time);
				}
				printf("Aendere Entscheidung\n");
				if(NextRandomSeed)
					DecisionGameStates.begin()->second.Rand();
				assert(CurrentVRamTime - DecisionGameStates.begin()->first.Time < DecisionTime);
				Game = DecisionGameStates.begin()->second;
				NewDecisions = DecisionGameStates.begin()->first;
				continue;
				throw;//////////////////////
			}
			if(NewDecisions.HasCombinations())
			{
				printf("Entscheidung um %i\n", GameRam::last_ram.CurrentTime);
				DecisionGameStates[NewDecisions] = GameRam::last_ram;
			}
			NewDecisions = DecisionList(Game.CurrentTime);
		}
		return true;
	}*/
};

std::vector<GameCombination> GameCombinations(1);

std::multiset<ShotInfoList> ShotInfosVariety;
void Player::Run()
{
//	ShellExecuteA(0, "open", "C:\\C++-Programme\\Asteroids\\vcmamed.exe", "", 0, SW_SHOW);
//	FramePacket last_frame;
	byte changed[0x100] = {0};
	FramePacket frame;
//	GameStatus game;
	KeysPacket keys_packets[10];
	char prevframe = 0;
	int t = 0;
	char current_ping=0;
	char last_ping=127;
	__int64 Score = 0;
	byte StartSeed = 0;
//	DecisionList Decisions;
//	std::map<int, GameRam> DecisionGameRams;
	word* VRams[DecisionTime];
	for(int i = 0; i < DecisionTime; i++)
		VRams[i] = new word[512];
	int CurrentVRam = -1;
	int CurrentVRamTime = 0;

	GameCombinations[0].Game.StartNewGame();

#if 0
	std::ofstream out("AsteroidsSave.dat", std::ios::binary);
#else
	std::ifstream in("AsteroidsSave.dat", std::ios::binary);
#endif

	int FutureShots = 18;
	//int MaxNeeded = 0;

	for(;;)
	{
		MSG msg;
		while(PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
		{
			if(msg.message==WM_QUIT)
				return;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}

		if(CurrentGameRam != -1)
		{
			WaitMessage();
			continue;
		}

		++current_ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
		keys_packets[t%10].ping = current_ping;
		if(updating)SendPacket(keys_packets[t%10]);
		++t;         // Zeit
		if(updating)ReceivePacket(frame);

#if 0
		out.write(frame.vectorram, 1024);
		out.write((char*)frame.ram, 0x300);
#else
		in.read(frame.vectorram, 1024);
		in.read((char*)frame.ram, 0x300);
		if(in.fail())
			return;
#endif


		/*const int MaxSameShotInfos = 10;
		if(ShotInfosVariety.empty())
		{
			ShotInfosVariety.insert(ShotInfoList());
#ifndef USER_CONTROL
			for(int i = 0; i <= FutureShots; i++)
			{
				std::multiset<ShotInfoList> NewShotInfosVariety;
				int Index = 0;
				for(std::multiset<ShotInfoList>::iterator j = ShotInfosVariety.begin();
					j != ShotInfosVariety.end();
					j++)
				{
					if(++Index == MaxSameShotInfos)
						break;
					gameram.CalculateNextShot(*j, 0, NewShotInfosVariety);
				}
				assert(!NewShotInfosVariety.empty());
				ShotInfosVariety = NewShotInfosVariety;
			}
#endif
		}*/

		/*while(ShotInfos.size() < 4)
		{
			if(ShotInfos.size() == 3 && ShotInfos[0].CollisionTime == MaxCollisionTime)
			{
				int ShootTime = ShotInfos[0].Time;
				gameram.CalculateNextShot(ShotInfos, MaxCollisionTime, 0);
				int MinMaxCollisionTime = MaxCollisionTime;
				int BestDelay;

				//printf("Test\n");
				for(int i = 1; i <= 2 ; i++)
				{
					std::vector<ShotInfo> ShotInfos2 = EmptyShotInfos;
					int MaxCollisionTime2 = 0;
					gameram.CalculateNextShot(ShotInfos2, MaxCollisionTime2, ShootTime+i);
					if(MaxCollisionTime2 >= MinMaxCollisionTime)
						break;
					gameram.CalculateNextShot(ShotInfos2, MaxCollisionTime2, 0);
					if(MaxCollisionTime2 < MinMaxCollisionTime)
					{
						ShotInfos = ShotInfos2;
						MinMaxCollisionTime = MaxCollisionTime2;
						BestDelay = i;
					}
				}
				//printf("TestEnde\n");
#ifdef PRINT_DEBUG_INFO
				if(MinMaxCollisionTime < MaxCollisionTime)
					printf("Juhuu. Spare %i mit der Verzoegerung %i\n", MaxCollisionTime - MinMaxCollisionTime, BestDelay);
#endif
				MaxCollisionTime = MinMaxCollisionTime;
			}
			else
				gameram.CalculateNextShot(ShotInfos, MaxCollisionTime, 0);
		}*/
		if (frame.frameno != ++prevframe /*|| frame.ping != keys.ping*/)
		{
			if(t != 1)
				printf("%d Frames verloren.\n", frame.frameno - prevframe);
			prevframe = frame.frameno;
		}

/*		if(updating)
		{
			if(frame.frameno == char(prevframe+1))
			{
				int i = 0;
				for(; i<10; i++)
					if(keys_packets[i].ping==last_ping)//frame.ping-1)
						break;
				if(i==10)
					printf("Fehler\n");
				else
				{*/
		//printf("Move Key: %x Ping: %x\n", keys_packets[i].keys & 0x1f, keys_packets[i].ping);
		//printf("Frame Hash: %x\n", gameram.Hash());
		if(++CurrentVRam == DecisionTime)
			CurrentVRam = 0;
		memcpy(VRams[CurrentVRam], frame.vectorram, 1024);
		CurrentVRamTime = GameCombinations[0].Game.CurrentTime;
		std::vector<GameCombination> NewGameCombinations;
		for(size_t i = 0; i < GameCombinations.size();)
		{
			if(!GameCombinations[i].Move(VRams, CurrentVRam, CurrentVRamTime, frame.ram, CurrentVRamTime+1, DecisionList(CurrentVRamTime), NewGameCombinations, false, 0))
			{
				printf("Loesche simultanen Spielzustand #%i\n", i);
				GameCombinations.erase(GameCombinations.begin()+i);
			}
			else
				i++;
		}
		for(size_t i = 0; i < NewGameCombinations.size(); i++)
			GameCombinations.push_back(NewGameCombinations[i]);
		assert(!GameCombinations.empty());
		int correct = 0;
		for(size_t i = 0; i < GameCombinations.size();)
		{
			if(GameCombinations[i].Check(frame.ram, (int)i))
				correct++;
//			{
//				printf("Loesche simultanen Spielzustand weil eigentlich falsch #%i\n", i);
//				GameCombinations.erase(GameCombinations.begin()+i);
//			}
//			else
				i++;
		}
		if(!correct)
			printf("Keine richtigen Gamestates!\n");
		//assert(correct != 0);
		assert(!GameCombinations.empty());
/*		int TargetTime = gameram.CurrentTime+1;
		while(gameram.CurrentTime != TargetTime)
		{
			try
			{
				assert(CurrentVRamTime - gameram.CurrentTime < DecisionTime);
				word* VRam = VRams[(CurrentVRam - (CurrentVRamTime - gameram.CurrentTime) + DecisionTime) % DecisionTime];
				DecisionAdded = false;
				gameram.Move_(KeysPacket(), ShotInfo(), frame.ram, VRam, Decisions);
			}
			catch(VRamInvalidException)
			{
				if(DecisionAdded)
				{
					printf("Entscheidung um %i\n", GameRam::last_ram.CurrentTime);
					DecisionGameRams[GameRam::last_ram.CurrentTime] = GameRam::last_ram;
				}
				printf("Aendere Entscheidung\n");
				assert(!Decisions.empty());
				while(Decisions.begin()->second.NextDecision())
				{
					Decisions.erase(Decisions.begin());
					assert(!Decisions.empty());
					printf("Springe zu Zeitpunkt %i zurueck\n", Decisions.begin()->first.GetTime());
				}
				assert(DecisionGameRams.find(Decisions.begin()->first.GetTime()) != DecisionGameRams.end());
				assert(CurrentVRamTime - Decisions.begin()->first.GetTime() < DecisionTime);
				gameram = DecisionGameRams[Decisions.begin()->first.GetTime()];
				if(Decisions.find(DecisionKey::RandomSeed(gameram.CurrentTime)) != Decisions.end() &&
					Decisions[DecisionKey::RandomSeed(gameram.CurrentTime)].GetTriesLeft() != gameram.RandomSeedTriesLeft)
				{
					assert(gameram.RandomSeedTriesLeft > 0);
					gameram.RandomSeedTriesLeft--;
					assert(Decisions[DecisionKey::RandomSeed(gameram.CurrentTime)].GetTriesLeft() == gameram.RandomSeedTriesLeft);
					gameram.Rand();
					DecisionGameRams[Decisions.begin()->first.GetTime()] = gameram;
					printf("Naechster Seed. Noch %i\n", gameram.RandomSeedTriesLeft);
				}
				continue;
				throw;//////////////////////
			}
			if(DecisionAdded)
			{
				printf("Entscheidung um %i\n", GameRam::last_ram.CurrentTime);
				DecisionGameRams[GameRam::last_ram.CurrentTime] = GameRam::last_ram;
			}
		}
		gameram.Check(frame.ram, keys_packets[i], ShotInfo(), false, server_ip, sd, Decisions);				*/
/*				}
			}
			else if(t != 1)
				printf("%i Paket(e) verloren\n", int(frame.frameno - prevframe+char(1)));
			if(prevframe-frame.frameno >= 0 && prevframe-frame.frameno < 10)
			{
				printf("Paket ignoriert\n");
				continue;
			}
			//gameram.Check(frame.ram, keys_packets[0], ShotInfo(), true, 0, 0);
			last_ping = frame.ping;
			//if(frame.frameno != prevframe+1)
			//	printf("Frame Hash: %x\n", gameram.Hash());
		}
		else*/
/*		{
			const ShotInfoList ShotInfos = *ShotInfosVariety.begin();//Darf keine Referenz sein, da wir unten die Daten brauchen, whrend wir das multiset ndern.
			//int Needed = abs(NeededRotation(ShotInfos[0].TargetDirection, ShotInfos[1].TargetDirection, ShotInfos[1].Dir));
			//if(Needed > MaxNeeded)
			//	printf("Neues Max bei %i um %i\n", MaxNeeded = Needed, ShotInfos[1].Time);
			pScore = &Score;
			gameram.Move(ShotInfos[0], ShotInfos[1]);
			pScore = 0;
			if(ShotInfos[0].Time == gameram.CurrentTime-1)
			{
				std::multiset<ShotInfoList> NewShotInfosVariety;
				int Index = 0;
				for(std::multiset<ShotInfoList>::iterator i = ShotInfosVariety.begin();
					i != ShotInfosVariety.end();
					i++)
				{
					if(!(*i).SameMovement(ShotInfos))
						continue;
					if(++Index == MaxSameShotInfos)
						break;
					//ShotInfoList OldList = *i;
					i->DeleteFirst();
					gameram.CalculateNextShot(*i, 0, NewShotInfosVariety);
				}
				assert(!NewShotInfosVariety.empty());
				ShotInfosVariety = NewShotInfosVariety;
			}
			RunningTime++;
			char Buffer[128];
			sprintf_s(Buffer, 128, "Sco: %i0 %i%%  Zeit: %i",
				int(Score), RunningTime*100/(60*60*5), RunningTime/60);
			SetWindowText(hwnd, Buffer);
			if(60*60*5 == RunningTime)
			{
				printf("Score nach 5 Minuten ohne Saucer mit Seed %02x: %i0\n", StartSeed, Score);
				//exit(0);
				gameram.StartNewGame();
				if(++StartSeed == 11)
				{
					StartSeed = 0;
					if(++FutureShots == -1)
						exit(0);
					printf("FutureShots: %i\n", FutureShots);
				}
				gameram.RandomSeed1 = StartSeed;
				RunningTime = 0;
				Score = 0;
				t = 0;
				ShotInfosVariety.clear();
				GameRamsHistory.clear();
			}
		}*/



		/*BitBlt(hdcMem, 0, yFont*2, xChars*xFont, (yChars-2)*yFont, hdcMem, 0, yFont, SRCCOPY);
		for(int i=0; i<0x100; i++)
		{
			const int Start = 0x200;
			if(t > 20 && frame.ram.GetRawRam()[i+Start] != last_frame.ram.GetRawRam()[i+Start])
				changed[i] = 255;
			SetTextColor(hdcMem, RGB(changed[i],0,0));
			if(changed[i]) changed[i]--;
			char Buffer[3];
			sprintf_s(Buffer, 3, "%2.2x", frame.ram.GetRawRam()[i+Start]);
			TextOut(hdcMem, i*xFont*2, yFont, Buffer, 2);
		}*/
		InvalidateRect(hwnd, 0, false);

//		last_frame = frame;


		//if(updating) InterpretScreen(frame, game);

		/*int Latency = 0;
		GameRam OriginalRam = gameram;
		if(updating)
		{
			Latency = current_ping - frame.ping + 1;
			printf("Latenz: %i\n", Latency);
			for(int i = 0; i < Latency; i++)
				gameram.Move(keys_packets[(t+i-Latency)%10], ShotInfos[(t+i-Latency)%10]);
		}

		keys_packets[t%10] = gameram.CalcDirInfos(&ShotInfos[t%10], 0, true, -1, 0, KeysPacket());
		if(Latency)
			gameram = OriginalRam;*/

		//keys_packets[t%10].fire(t%2 == 0);

		//GameRamsHistory.push_back(gameram);

		keys_packets[t%10].clear();
		if(GetForegroundWindow() == hwnd)
		{
			if(GetAsyncKeyState('Q') < 0)
				keys_packets[t%10].left(true);
			if(GetAsyncKeyState('W') < 0)
				keys_packets[t%10].right(true);
			if(GetAsyncKeyState('I') < 0)
				keys_packets[t%10].thrust(true);
			if(GetAsyncKeyState('O') < 0)
				keys_packets[t%10].fire(true);
			if(GetAsyncKeyState(VK_SPACE) < 0)
				keys_packets[t%10].hyperspace(true);
		}

		/*int min_dist = 0x7fffffff;
		int min_dx = 0;
		int min_dy = 0;
		if (game.ship_present)
		{
			for (int i=0; i<game.nasteroids; ++i)
			{   // nchstgelegenen Asteroiden suchen
				int dx = game.asteroids[i].x - game.ship_x;
				while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
				while (dx > 511) dx -= 1024;
				int dy = game.asteroids[i].y - game.ship_y;
				while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
				while (dy > 383) dy -= 768;
				int dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
				switch (game.asteroids[i].sf)
				{	// Abstand um den ungefhren Radius des Asteroiden korrigieren
					case 0:  // groer Asteroid
						dist -= 40*40;
						break;
					case 15: // mittlerer Asteroid
						dist -= 20*20;
						break;
					case 14: // kleiner Asteroid
						dist -= 8*8;
						break;
				}
				if (dist < min_dist)
				{
					min_dist = dist;
					min_dx = dx;
					min_dy = dy;
				}
			}
			if (game.saucer_present)
			{
				int dx = game.saucer_x - game.ship_x;
				while (dx < -512) dx += 1024;
				while (dx > 511) dx -= 1024;
				int dy = game.saucer_y - game.ship_y;
				while (dy < -384) dy += 768;
				while (dy > 383) dy -= 768;
				int dist = dx*dx+dy*dy;
				switch (game.saucer_size)
				{	// Abstand um den ungefhren Radius des UFOs korrigieren
				case 15: // groes UFO
					dist -= 20*12;
					break;
				case 14: // kleines UFO
					dist -= 10*6;
					break;
				}
				if (dist < min_dist)
				{
					min_dist = dist;
					min_dx = dx;
					min_dy = dy;
				}
			}

			// Schiff in Richtung auf das nchstgelegene Objekt drehen
			// mathematisch wird hier das Kreuzprodukt aus den Vektoren 
			// ship_dx/y/0 und min_dx/y/0 berechnet
			if (game.ship_dx * min_dy - game.ship_dy * min_dx > 0)
				keys_packets[t%10].left(true);
			else
				keys_packets[t%10].right(true);

			if (min_dist < 30*30)  // Flucht, wenn Kollision unausweichlich
				keys_packets[t%10].hyperspace(true);

			if (min_dist > 300*300/100) // beschleunigen, wenn nichts in der Nhe
				keys_packets[t%10].thrust(true);

			if (t % 2 == 0)  // Feuerknopf drcken, so schnell es geht
				keys_packets[t%10].fire(true);
		}*/
	}
}

void GameRam::Render(HDC hdc, int cx, int cy)
{
	SelectObject(hdc, GetStockObject(NULL_BRUSH));
	SelectObject(hdc, CreatePen(PS_SOLID, 0, RGB(255,255,0)));
	for(int Pass = 0; Pass < 2; Pass++)
	{
		for(int i = 0; i < NumObjects; i++)
		{
			if(Objects[i].Status==0)
				continue;
			if(Objects[i].Status < 0 && Pass != 0 || //Explosion im ersten Pass zeichnen
				Objects[i].Status >= 0 && Pass == 0)
				continue;
			int Size = 100;
			if(Objects[i].Status < 0)//Explosion
				Size = -Objects[i].Status;
			else if(i==PlayerIndex)
				Size = 12;
			else if(i==SaucerIndex && Objects[i].Status == 1)
				Size = -10;
			else if(i==SaucerIndex && Objects[i].Status == 2)
				Size = -20;
			else if(i<PlayerIndex && (Objects[i].Status&0x01))
				Size = 13;
			else if(i<PlayerIndex && (Objects[i].Status&0x02))
				Size = 20;
			else if(i<PlayerIndex && (Objects[i].Status&0x04))
				Size = 33;
			else if(i>SaucerIndex)
				Size = 4;
			else
				assert(0);
			for(int ax = 0; ax < Objects[i].cAltX; ax++)
			for(int ay = 0; ay < Objects[i].cAltY; ay++)
			{
				int x = int(Objects[i].AltPX[ax]) * cx / 0x2000;
				int y = int(Objects[i].AltPY[ay]) * cy / 0x1800;
				y = cy - y;
				if(Size > 0)
					Ellipse(hdc, x-Size*cx/1033, y-Size*cy/733, x+Size*cx/1033, y+Size*cy/733);
				else
					Rectangle(hdc, x+Size*cx/1033, y+Size*cy/733, x-Size*cx/1033, y-Size*cy/733);
				if(i==PlayerIndex)
				{
					MoveToEx(hdc, x, y, 0);
					LineTo(hdc, int(cos(float(ShipDirection)/255.f*6.283f)*20.0f)+x,
								int(sin(float(ShipDirection)/255.f*6.283f)*-20.0f)+y);
				}
				if(Objects[i].cAltX != 1 || Objects[i].cAltY != 1)
				{
					char Buffer[128];
					sprintf_s(Buffer, 128, "%ix%i", Objects[i].cAltX, Objects[i].cAltY);
					TextOut(hdc, x, y, Buffer, (int)strlen(Buffer));
				}
			}
		}
		//SelectObject(hdc, GetStockObject(WHITE_BRUSH));
		DeleteObject(SelectObject(hdc, GetStockObject(BLACK_PEN)));
	}

	for(std::multiset<ShotInfoList>::iterator j = ShotInfosVariety.begin();
		j != ShotInfosVariety.end();
		j++)
	{
		for(int i = 0; i < (int)j->size()-2; i++)
		{
			SelectObject(hdc, CreatePen(PS_SOLID, 0, RGB(i*255/int(j->size()-3), i*255/int(j->size()-3), i*255/int(j->size()-3))));
			assert((*j)[i].Time != MaxInt);
			int x = int((*j)[i].StartX) * cx / 0x2000;
			int y = int((*j)[i].StartY) * cy / 0x1800;
			y = cy - y;
			MoveToEx(hdc, x, y, 0);
			x = int((*j)[i].PositionX) * cx / 0x2000;
			y = int((*j)[i].PositionY) * cy / 0x1800;
			y = cy - y;
			LineTo(hdc, x, y);

			DeleteObject(SelectObject(hdc, GetStockObject(WHITE_PEN)));
		}
		break;
	}

	/*for(int x = 0; x < cx; x++)
	for(int y = x%2; y < cy; y+=2)
	{
		int xAst = x * 0x2000 / cx;
		int yAst = (cy-y) * 0x1800 / cy;
		for(int Object = SaucerIndex; Object >= 0; Object--)
		{
			if(Objects[Object].Status <= 0)
				continue;
			bool collision = AreObjectsNear(0x1F, xAst, yAst, 10,
											Object,
											Objects[Object].PositionX,
											Objects[Object].PositionY, Objects[Object].Status);
			if(collision)
				SetPixel(hdc, x, y, RGB(255,0,0));
		}
	}*/

}


void Player::InterpretScreen(FramePacket &packet, GameStatus& game)
{
	unsigned short vector_ram[512];
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;

	game.clear();

	/* Vektor-RAM in 16-Bit-Worte konvertieren. War in der ersten Version mal ein sportlicher
	Typecast: unsigned short *vector_ram = (unsigned short*)packet.vectorram;
	Das klappt aber nur auf Little-Endian-Systemen, daher besser portabel: */
	for (int i=0; i<512; ++i)
		vector_ram[i] = (unsigned char)packet.vectorram[2*i] | (unsigned char)packet.vectorram[2*i+1] << 8;

	if (vector_ram[0] != 0xe001 && vector_ram[0] != 0xe201)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	while (pc < 512)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				game.asteroids[game.nasteroids++].set(vx, vy, 1, vs);
				break;
			case 0x8ff:
				game.asteroids[game.nasteroids++].set(vx, vy, 2, vs);
				break;
			case 0x90d:
				game.asteroids[game.nasteroids++].set(vx, vy, 3, vs);
				break;
			case 0x91a:
				game.asteroids[game.nasteroids++].set(vx, vy, 4, vs);
				break;
			case 0x929:
				game.saucer_present = true;
				game.saucer_x = vx;
				game.saucer_y = vy;
				game.saucer_size = vs;
				break;
			}  
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if(vector_ram[pc] & 0x400)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if(vector_ram[pc+1] & 0x400)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				game.shots[game.nshots++].set(vx, vy);
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					game.ship_present = true;
					game.ship_x = vx;
					game.ship_y = vy;
					game.ship_dx = v1x - dx;
					game.ship_dy = v1y - dy;
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}   

}


void Asteroid::set(int x, int y, int type, int sf)
{
	this->x = x;
	this->y = y;
	this->type = type;
	this->sf = sf;
}

void Shot::set(int x, int y)
{
	this->x = x;
	this->y = y;
}

void GameStatus::clear(void)
{
	ship_present = false;
	saucer_present = false;
	nasteroids = 0;
	nshots = 0;
}

KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}

void Player::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

	do
	{
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select(int(sd)+1, &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(0);
		}
		break;
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(int(sd)+1, &readfds, &writefds, &exceptfds, &zero);
		if(FD_ISSET(sd, &readfds))
			printf("Paket weggeschmissen\n");
	} while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
	}
}

LRESULT CALLBACK WndProc (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static int	cxClient, cyClient ;
	static int xView=0, yView=0;
	
	switch (message)
	{
	case WM_CREATE:
	{
		::hwnd = hwnd;
		HDC hdcScreen = GetDC(hwnd);
		hBitmap = CreateCompatibleBitmap(hdcScreen, xChars*xFont, yChars*yFont);
		hdcMem  = CreateCompatibleDC(hdcScreen);
		SelectObject(hdcMem, hBitmap);
		ReleaseDC(hwnd, hdcScreen);

		SelectObject(hdcMem, CreateFont (0, 0, 0, 0, 0, 0, 0, 0, DEFAULT_CHARSET, 0, 0, 0, FIXED_PITCH, NULL));
		Rectangle(hdcMem, -1, -1, xChars*xFont+1, yChars*yFont+1);
		for(int i=0; i<0x100; i++)
		{
			char Buffer[3];
			sprintf_s(Buffer, 3, "%2.2x", i);
			TextOut(hdcMem, i*xFont*2, 0, Buffer, 2);
		}
/*		TEXTMETRIC tm;
		GetTextMetrics(hdcMem, &tm);
		xFont = tm.tmAveCharWidth;
		yFont = tm.tmHeight;*/
		return 0;
	}

	case WM_SIZE:
		cxClient = LOWORD (lParam) ;
		cyClient = HIWORD (lParam) ;
		while(xView+cxClient/xFont>xChars)
			xView--;
		return 0 ;

	case WM_KEYDOWN:
		if(wParam==VK_LEFT)
		{
			xView-=2;
			CurrentGameRam--;
			if(CurrentGameRam < 0)
				CurrentGameRam = (int)GameRamsHistory.size()-1;
		}
		else if(wParam==VK_RIGHT)
		{
			xView+=2;
			CurrentGameRam++;
			if(CurrentGameRam >= (int)GameRamsHistory.size())
				CurrentGameRam = (int)GameRamsHistory.size()-1;
		}
		else if(wParam==VK_UP)
		{
			yView--;
			CurrentGameRam = -1;
		}
		else if(wParam==VK_DOWN)
		{
			yView++;
//			ShotInfo S;
//			while(CurrentGameRam != -1)
//				GameRamsHistory[CurrentGameRam].CalcDirInfos(&S, 0, true, -1, 0, KeysPacket());
		}
		else
			return 0;
		if(xView<0) xView=0;
		if(yView<0) yView=0;
		while(xView+cxClient/xFont>xChars) xView--;
		InvalidateRect(hwnd, 0, false);
		return 0;

	/*case WM_LBUTTONDOWN:
		updating = !updating;
		if(!updating)
		{
			gameram.StartNewGame();
			RunningTime = 0;
		}
		return 0;*/

	case WM_PAINT:
	{
		PAINTSTRUCT	ps;
		HDC hdcScreen = BeginPaint (hwnd, &ps) ;

		HBITMAP hBitmap = CreateCompatibleBitmap(hdcScreen, cxClient, cyClient);
		HDC hdc = CreateCompatibleDC(hdcScreen);
		SelectObject(hdc, hBitmap);

		RECT rc;
		SetRect(&rc, 0, 0, cxClient, cyClient);
		FillRect(hdc, &rc, (HBRUSH)GetStockObject(updating ? WHITE_BRUSH : LTGRAY_BRUSH));

		//BitBlt(hdc, 0, 0, cxClient, cyClient,
		//       hdcMem, xView*xFont, yView*yFont, SRCCOPY);
		if(CurrentGameRam == -1)
		{
			for(size_t i = 0; i < GameCombinations.size(); i++)
				GameCombinations[i].Game.Render(hdc, cxClient, cyClient);
		}
		else
		{
			//ShotInfo S;
			//GameRamsHistory[CurrentGameRam].CalcDirInfos(&S, 0, true, -1, 0, KeysPacket());
			GameRamsHistory[CurrentGameRam].Render(hdc, cxClient, cyClient);
		}

		char Buffer[512];
		sprintf_s(Buffer, 512, "Zeit: %i Zustnde: %i", GameCombinations[0].Game.CurrentTime, GameCombinations.size());
		TextOut(hdc, 0, 0, Buffer, (int)strlen(Buffer));

		BitBlt(hdcScreen, 0, 0, cxClient, cyClient, hdc, 0, 0, SRCCOPY);
		DeleteDC(hdc);
		DeleteObject(hBitmap);
		EndPaint (hwnd, &ps) ;
		return 0 ;

	}
	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
	}
	return DefWindowProc (hwnd, message, wParam, lParam) ;
}